<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('remuneracoes', function (Blueprint $table) {
            $table->id();
            $table->string('tipo');            
            $table->string('descricao');
            $table->decimal('valor', 15, 2);            
            $table->string('observacao')->nullable();            
            $table->string('status')->default('Ativo');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('remuneracoes');
    }
};
