<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coordenadas_bancarias', function (Blueprint $table) {
            $table->id();
            $table->string('nomeBanco');
            $table->string('siglaBanco');
            $table->string('ContaBancaria');
            $table->string('Iban');
            $table->foreignId('id_titular')->constrained('funcionarios')->onDelete('cascade')->onUpdate('cascade');
            $table->string('estado')->enum(['Ativo', 'Inativo'])->default('Ativo');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coordenadas_bancarias');
    }
};
