<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('funcionarios', function (Blueprint $table) {
            $table->id();
            $table->string('nomeCompleto');
            $table->string('numeroDocumento');
            $table->string('tipoDocumento');
            $table->string('checkDocumento')->enum(['1', '0'])->default('0');
            $table->string('telefone')->unique();
            $table->string('checkTelefone')->enum(['1', '0'])->default('0');
            $table->string('email')->unique();
            $table->string('numeroColaborador')->nullable();
            $table->string('estado')->enum(['Ativo', 'Inativo'])->default('Ativo');
            $table->foreignId('id_departamento')->constrained('departamentos')->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('id_funcao')->constrained('funcoes')->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('id_grupo_pessoal')->constrained('grupo_pessoais')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('funcionarios');
    }
};
