<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('projectos', function (Blueprint $table) {
            // Campo para o ID do admin responsável pelo projeto
            $table->unsignedBigInteger('admin_responsavel_id')->nullable()->after('status');
            
            // Campo para data da última mudança de status
            $table->timestamp('data_mudanca_status')->nullable()->after('admin_responsavel_id');
            
            // Chave estrangeira para o admin responsável
            $table->foreign('admin_responsavel_id')->references('id')->on('users')->onDelete('set null');
            
            // Índice para performance
            $table->index(['admin_responsavel_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('projectos', function (Blueprint $table) {
            // Remover chave estrangeira e campos
            $table->dropForeign(['admin_responsavel_id']);
            $table->dropColumn(['admin_responsavel_id', 'data_mudanca_status']);
        });
    }
};
