<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('relatorios_execucao', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('projeto_id');
            $table->unsignedBigInteger('usuario_id');
            $table->text('descricao_tecnica');
            $table->text('descricao_financeira');
            $table->date('periodo_inicio');
            $table->date('periodo_fim');
            $table->decimal('percentual_fisico', 5, 2)->nullable();
            $table->decimal('valor_executado', 15, 2)->nullable();
            $table->json('anexos')->nullable();
            $table->text('observacoes')->nullable();
            $table->enum('status', ['pendente', 'aprovado', 'rejeitado'])->default('pendente');
            $table->text('motivo_rejeicao')->nullable();
            $table->unsignedBigInteger('aprovado_por')->nullable();
            $table->timestamp('aprovado_em')->nullable();
            $table->timestamps();
            
            // Chaves estrangeiras
            $table->foreign('projeto_id')->references('id')->on('projectos')->onDelete('cascade');
            $table->foreign('usuario_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('aprovado_por')->references('id')->on('users')->onDelete('set null');
            
            // Índices
            $table->index(['projeto_id', 'status']);
            $table->index('usuario_id');
            $table->index('periodo_inicio');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('relatorios_execucao');
    }
};
