<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('programacao_financeiras', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('projeto_id');
            $table->year('ano');
            $table->decimal('valor', 15, 2); // Suporte para valores até 999.999.999.999,99
            $table->date('data_inicial');
            $table->date('data_final');
            $table->text('descricao');
            $table->timestamps();

            $table->foreign('projeto_id')->references('id')->on('projectos')->onDelete('cascade');
            
            $table->index(['projeto_id', 'ano']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('programacao_financeiras');
    }
};
