<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cronograma_fisicos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('projeto_id');
            $table->string('ano');
            $table->date('data_inicio');
            $table->date('data_fim');
            $table->decimal('percentual', 5, 2); // Ex: 99.99%
            $table->text('descricao');
            $table->timestamps();

            $table->foreign('projeto_id')->references('id')->on('projectos')->onDelete('cascade');

            $table->index(['projeto_id', 'ano']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cronograma_fisicos');
    }
};
