<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projectos', function (Blueprint $table) {
            $table->id();

            // Informações básicas do projeto
            $table->string('codProjecto')->unique()->nullable();
            $table->string('nomeProjecto');
            $table->text('descricaoObjectivo')->nullable();
            $table->decimal('limiteorcamentalP', 15, 2)->nullable();
            $table->integer('beneficiarioDP')->nullable();
            $table->date('duracaoP')->nullable(); // Data de início
            $table->date('duracaoF')->nullable(); // Data de fim

            // Detalhes do projeto
            $table->text('justificacao')->nullable();
            $table->text('aprovadoPor')->nullable();
            $table->string('financeador')->nullable();
            $table->string('Url_contratoP')->nullable();
            $table->string('ambito')->nullable();
            $table->string('mFuncionamento')->nullable();
            $table->string('localizacao_projecto')->nullable();
            $table->text('impactoSocial')->nullable();
            $table->text('tecnicoEngenharia')->nullable();
            $table->text('analiseEfectividade')->nullable();
            $table->text('viabilidadeEconomica')->nullable();
            $table->text('impactoAmbiental')->nullable();
            $table->text('mitigacaoImpactos')->nullable();

            // informações Bancários
            $table->string('nomeInst')->nullable();
            $table->string('enderecoAgencia')->nullable();
            $table->string('contactoAgencia')->nullable();
            $table->string('numeroConta')->nullable();
            $table->string('iban')->nullable();
            $table->string('swif')->nullable();
            $table->string('assinante1')->nullable();
            $table->string('assinante2')->nullable();
            $table->string('assinante3')->nullable();
            $table->string('assinante4')->nullable();
            $table->string('nif')->nullable();

            // Indicadores
            $table->integer('empregosDirectos')->default(0);
            $table->integer('kitsDistribuidos')->default(0);

            // Relacionamentos
            $table->unsignedBigInteger('tipoProjectFK')->nullable();
            $table->unsignedBigInteger('gestor_projectoFK')->nullable();
            $table->unsignedBigInteger('tecnico_projectoFK')->nullable();

            // Arquivos e status
            $table->string('facturaPath')->nullable();
            $table->enum('status', [0, 1, 2, 3, 4, 5])->default(0);

            $table->timestamps();

            // Chaves estrangeiras
            $table->foreign('tipoProjectFK')->references('id')->on('tipos_projeto')->onDelete('set null');
            $table->foreign('gestor_projectoFK')->references('id')->on('users')->onDelete('set null');
            $table->foreign('tecnico_projectoFK')->references('id')->on('users')->onDelete('set null');

            // Índices para performance
            $table->index(['gestor_projectoFK']);
            $table->index(['tipoProjectFK']);
            $table->index(['status']);
            $table->index(['duracaoP', 'duracaoF']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projectos');
    }
};
