<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bancos', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('sigla')->nullable(true);
            $table->string('numeroConta');
            $table->string('iban');
            $table->string('swift');
            $table->string('status');  
            $table->string('assinante1');  
            $table->string('assinante2')->nullable(true);;  
            $table->string('assinante3')->nullable(true);;  
            $table->string('assinante4')->nullable(true);;  
            $table->foreignId('entidade_id')->constrained('entidades')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bancos');
    }
};
