<?php

namespace App\Providers;

use Illuminate\Pagination\Paginator;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Blade;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Forçar HTTPS em produção
        if (config('app.env') === 'production') {
            URL::forceScheme('https');
        }

        // Adicionar diretiva Blade personalizada para carregar ativos corretamente em qualquer ambiente
        Blade::directive('loadAsset', function ($path) {
            return "<?php echo app()->environment('production') ? secure_asset($path) : asset($path); ?>";
        });
        
        Paginator::useBootstrapFive();
    }
}
