<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $table = 'users';

    protected $fillable = [
        'name',
        'email',
        'email_verified_at',
        'password',
        'admin',
        'client',
        'telefone',
        'id_entidade',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * Relacionamento com relatórios de execução criados pelo usuário
     */
    public function relatoriosExecucao()
    {
        return $this->hasMany(RelatorioExecucao::class, 'usuario_id');
    }

    /**
     * Relacionamento com relatórios aprovados pelo usuário
     */
    public function relatoriosAprovados()
    {
        return $this->hasMany(RelatorioExecucao::class, 'aprovado_por');
    }

    /**
     * Relacionamento com projetos como técnico responsável
     */
    public function projetosComoTecnico()
    {
        return $this->hasMany(Projecto::class, 'tecnico_projectoFK');
    }

    /**
     * Relacionamento com projetos como gestor
     */
    public function projetosComoGestor()
    {
        return $this->hasMany(Projecto::class, 'gestor_projectoFK');
    }

    /**
     * Relacionamento com a entidade a que este usuário pertence
     */
    public function entidade()
    {
        return $this->belongsTo(Entidade::class, 'id_entidade');
    }
}
