<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Remuneracao extends Model
{
    use HasFactory;

    protected $table='remuneracoes';
    
    protected $fillable = [
        'tipo',
        'descricao',
        'valor',
        'observacao',
        'status'
    ];

    protected $casts = [
        'valor' => 'decimal:2',
    ];

    // Scopes
    public function scopeAtivos($query)
    {
        return $query->where('status', 'Ativo');
    }

    public function scopeInativos($query)
    {
        return $query->where('status', 'Inativo');
    }

    /**
     * Relacionamento com Funcionários (muitos-para-muitos) via pivot funcionario_remuneracao
     */
    public function funcionarios()
    {
        return $this->belongsToMany(Funcionario::class, 'funcionario_remuneracao', 'remuneracao_id', 'funcionario_id')
            ->withPivot(['valor', 'observacao', 'status'])
            ->withTimestamps();
    }
}
