<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProgramacaoFinanceira extends Model
{
    use HasFactory;

    protected $table = 'programacao_financeiras';

    protected $fillable = [
        'projeto_id',
        'descricao',
        'ano',
        'valor',
        'data_inicial',
        'data_final',
    ];

    protected $dates = [
        'data_inicial',
        'data_final',
    ];

    protected $casts = [
        'valor' => 'decimal:2',
    ];

    /**
     * Relacionamento com o projeto
     */
    public function projeto()
    {
        return $this->belongsTo(Projecto::class, 'projeto_id');
    }
}
