<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pagamento extends Model
{
    use HasFactory;

    protected $fillable = [
        'projecto_id',
        'descricao',
        'valor',
        'anexo',
        'data',
        'user_id'
    ];

    public function projecto()
    {
        return $this->belongsTo(Projecto::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
