<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GrupoPessoais extends Model
{
    use HasFactory;

    protected $table = 'grupo_pessoais';

    // Campos da tabela
    protected $fillable = ['nomeGrupo', 'ObservacaoGrupo', 'estado'];

    /**
     * Mutator para definir o estado padrão como 'Ativo'
     */
    protected static function boot()
    {
        parent::boot();

        static::saving(function ($grupoPessoal) {
            if (!$grupoPessoal->exists) {
                $grupoPessoal->estado = $grupoPessoal->estado ?? 'Ativo';
            }
        });
    }

    /**
     * Accessor para formatar o estado
     */
    public function getEstadoAttribute($value)
    {
        return ucfirst($value);
    }

    /**
     * Scope para grupos pessoais ativos
     */
    public function scopeAtivos($query)
    {
        return $query->where('estado', 'Ativo');
    }

    /**
     * Scope para grupos pessoais inativos
     */
    public function scopeInativos($query)
    {
        return $query->where('estado', 'Inativo');
    }

    /**
     * Scope para buscar por nome do grupo pessoal
     */
    public function scopePorNome($query, $nome)
    {
        return $query->where('nomeGrupo', 'like', '%' . $nome . '%');
    }
}
