<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Funcoes extends Model
{
    use HasFactory;

    protected $table = 'funcoes';

    // Campos da tabela
    protected $fillable = ['nomeFuncao', 'ObservacaoFuncao', 'estado'];

    /**
     * Mutator para definir o estado padrão como 'Ativo'
     */
    protected static function boot()
    {
        parent::boot();

        static::saving(function ($funcao) {
            if (!$funcao->exists) {
                $funcao->estado = $funcao->estado ?? 'Ativo';
            }
        });
    }

    /**
     * Accessor para formatar o estado
     */
    public function getEstadoAttribute($value)
    {
        return ucfirst($value);
    }

    /**
     * Scope para funções ativas
     */
    public function scopeAtivos($query)
    {
        return $query->where('estado', 'Ativo');
    }

    /**
     * Scope para funções inativas
     */
    public function scopeInativos($query)
    {
        return $query->where('estado', 'Inativo');
    }

    /**
     * Scope para buscar por nome da função
     */
    public function scopePorNome($query, $nome)
    {
        return $query->where('nomeFuncao', 'like', '%' . $nome . '%');
    }
}
