<?php

namespace App\Models;

use App\Models\Banco;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Entidade extends Model
{
    use HasFactory;

    // Nome da tabela
    protected $table='entidades';

    // Campos da tabela
    protected $fillable=['nomeRegistro','nomeComercial','tipo','nif','email','endereco','cidade','pais','website','logo','urldocumentacao','status','obs','contactoPrimario','contactoSecundario'];

    // Relacionamento com a tabela BANCOS
    public function bancos(){
        return $this->hasMany(Banco::class);
    }
    
    // Relacionamento com a tabela USERS
    public function usuarios(){
        return $this->hasMany(User::class, 'id_entidade');
    }
}
