<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Departamento extends Model
{
    use HasFactory;

    protected $table = 'departamentos';

    // Campos da tabela
    protected $fillable = ['nomeDepartamento', 'ObservacaoDepartamento', 'estado'];

    /**
     * Mutator para definir o estado padrão como 'Ativo'
     */
    protected static function boot()
    {
        parent::boot();

        static::saving(function ($departamento) {
            if (!$departamento->exists) {
                $departamento->estado = $departamento->estado ?? 'Ativo';
            }
        });
    }

    /**
     * Accessor para formatar o estado
     */
    public function getEstadoAttribute($value)
    {
        return ucfirst($value);
    }

    /**
     * Scope para departamentos ativos
     */
    public function scopeAtivos($query)
    {
        return $query->where('estado', 'Ativo');
    }

    /**
     * Scope para departamentos inativos
     */
    public function scopeInativos($query)
    {
        return $query->where('estado', 'Inativo');
    }

    /**
     * Scope para buscar por nome do departamento
     */
    public function scopePorNome($query, $nome)
    {
        return $query->where('nomeDepartamento', 'like', '%' . $nome . '%');
    }
}
