<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CronogramaFisico extends Model
{
    use HasFactory;

    protected $table = 'cronograma_fisicos';

    protected $fillable = [
        'projeto_id',
        'descricao',
        'ano',
        'data_inicio',
        'data_fim',
        'percentual',

    ];

    protected $dates = [
        'data_inicio',
        'data_fim',
    ];

    /**
     * Relacionamento com o projeto
     */
    public function projeto()
    {
        return $this->belongsTo(Projecto::class, 'projeto_id');
    }
}
