<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Banco extends Model
{
    use HasFactory;
    // Nome da tabela
    protected $table='bancos';

    // Campos da tabela
    protected $fillable=['nome','sigla','numeroConta','iban','swift','status','assinante1','assinante2','assinante3','assinante4','entidade_id'];

    // Relacionamento com a tabela ENTIDADE
    public function entidade(){
        return $this->belongsTo(Entidade::class);
    }

}
