<?php

namespace App\Mail;

use App\Models\SalarioProcessado;
use App\Models\ProcessamentoSalario;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Mail\Mailables\Attachment;
use Illuminate\Queue\SerializesModels;
use Barryvdh\DomPDF\Facade\Pdf;

class ReciboSalarioMail extends Mailable
{
    use Queueable, SerializesModels;

    public $salario;
    public $processamento;

    /**
     * Create a new message instance.
     */
    public function __construct(SalarioProcessado $salario, ProcessamentoSalario $processamento)
    {
        $this->salario = $salario;
        $this->processamento = $processamento;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Recibo de Salário - ' . $this->processamento->nomeMes . '/' . $this->processamento->ano,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.recibo-salario',
            with: [
                'salario' => $this->salario,
                'processamento' => $this->processamento,
            ]
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        // Gerar PDF do recibo
        $pdf = Pdf::loadView('pdf.recibo-salario', [
            'salario' => $this->salario,
            'processamento' => $this->processamento
        ]);

        $nomeArquivo = 'Recibo_' . str_replace(' ', '_', $this->salario->nomeTrabalhador) . '_' . 
                       $this->processamento->nomeMes . '_' . $this->processamento->ano . '.pdf';

        return [
            Attachment::fromData(fn () => $pdf->output(), $nomeArquivo)
                ->withMime('application/pdf'),
        ];
    }
}
