<?php

namespace App\Jobs;

use App\Mail\NovoUsuarioMail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class EnviarEmailNovoUsuarioJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $nome;
    protected $email;
    protected $senha;
    protected $tipoUsuario;

    /**
     * Create a new job instance.
     */
    public function __construct($nome, $email, $senha, $tipoUsuario)
    {
        $this->nome = $nome;
        $this->email = $email;
        $this->senha = $senha;
        $this->tipoUsuario = $tipoUsuario;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $email = new NovoUsuarioMail(
            $this->nome,
            $this->email,
            $this->senha,
            $this->tipoUsuario
        );

        Mail::to($this->email)->send($email);
    }
}
