<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProjetoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [

            // Regras para o projecto
            'codProjecto' => 'required',
            'nomeProjecto' => 'required',
            'tipoProjectFK' => 'required',
            'descObjectivo' => 'nullable|required',
            'limiteorcamentalP' => 'required|numeric',
            'beneficiarioDP' => 'required|numeric',
            'duracaoP' => 'required|date',
            'duracaoF' => 'required|date|after_or_equal:duracaoP',
            'aprovadopor' => 'required|string|max:555',
            'facturaP' => 'required|file|mimes:pdf|max:10240',
            'justificacao' => 'required|string|max:555',
            'ambito' => 'required',
            'mFuncionamento' => 'required',
            'localizacao_projecto' => 'required',
            'nomeInst' => 'required',
            'enderecoAgencia' => 'required',
            'contactoAgencia' => 'required|numeric',
            'numeroConta' => 'required',
            'iban' => 'required',
            'Assinante1' => 'required',
            'Assinante2' => 'required',
            'nif' => 'required',
            'impactoSocial' => 'required|file|mimes:pdf|max:10240',
            'empregosDirectos' => 'required|numeric',
            'kitsDistribuidos' => 'required|numeric',

            // Regras para actividades

            'actividadeDescricao.*' => 'required|string',
            'actividadeAno.*' => 'required|numeric',
            'actividadeDataInicio.*' => 'required|date',
            'actividadeDataFim.*' => 'required|date|after_or_equal:actividadeDataInicio.*',
            'actividadePercentual.*' => 'required|numeric|min:0|max:100',

            // Regras para programação financeira
            'despesaDescricao.*' => 'required|string',
            'despesaAno.*' => 'required|numeric',
            'despesaValor.*' => 'required|numeric|min:0',
            'despesaDatainicial.*' => 'required|date',
            'despesaDatafinal.*' => 'required|date|after_or_equal:despesaDatainicial.*',
            'despesaCategoria.*' => 'required|string',
        ];
    }

    public function messages(): array
    {
        return [
            // Validações para o projecto
            'codProjecto.required' => 'Informe o código do projecto',
            'nomeProjecto.required' => 'Informe o nome do projecto',
            'tipoProjectFK.required' => 'Informe o tipo do projecto',
            'descObjectivo.required' => 'Informe a descrição e objectivos ',
            'descObjectivo.nullable' => 'Informe a descrição e objectivos ',
            'limiteorcamentalP.required' => 'Informe o limite orçamental do projecto',
            'limiteorcamentalP.numeric' => 'O limite orçamental deve ser um número',
            'beneficiarioDP.required' => 'Informe o Nº de beneficiários do projecto',
            'beneficiarioDP.numeric' => 'O Nº de beneficiários do projecto deve ser um número',
            'duracaoP.required' => 'Informe a data de início do projecto',
            'duracaoF.required' => 'Informe a data de término do projecto',
            'duracaoP.date' => 'A data de início do projecto deve ser uma data válida',
            'duracaoF.date' => 'A data de término do projecto deve ser uma data válida',
            'duracaoF.after_or_equal' => 'A data de término do projecto deve ser igual ou posterior à data de início',
            'aprovadopor.required' => 'Informe o nome do responsável do projecto',
            'aprovadopor.string' => 'O nome do responsável do projecto deve ser uma string',
            'aprovadopor.max' => 'O nome do responsável do projecto não pode ser maior que 555 caracteres',
            'justificacao.required' => 'Informe a justificação do projecto',
            'justificacao.string' => 'A justificação do projecto deve ser uma string',
            'justificacao.max' => 'A justificação do projecto não pode ser maior que 555 caracteres',
            'facturaP.required' => 'Informe a factura do projecto',
            'facturaP.file' => 'A factura do projecto deve ser um arquivo',
            'facturaP.mimes' => 'A factura do projecto deve ser um arquivo do tipo: pdf',
            'facturaP.max' => 'A factura do projecto não pode ser maior que 10 MB',
            'ambito.required' => 'Informe o âmbito do projecto',
            'ambito.string' => 'O âmbito do projecto deve ser uma string',
            'ambito.max' => 'O âmbito do projecto não pode ser maior que 555 caracteres',
            'mFuncionamento.required' => 'Informe a metodologia de funcionamento do projecto',
            'mFuncionamento.string' => 'A metodologia de funcionamento do projecto deve ser uma string',
            'mFuncionamento.max' => 'A metodologia de funcionamento do projecto não pode ser maior que 555 caracteres',
            'localizacao_projecto.required' => 'Informe a localização do projecto',
            'localizacao_projecto.string' => 'A localização do projecto deve ser uma string',
            'nomeInst.required' => 'Informe o nome da instituição',
            'enderecoAgencia.required' => 'Informe o endereço da Agência',
            'enderecoAgencia.string' => 'O endereço da Agência deve ser uma string',
            'contactoAgencia.required' => 'Informe o contacto da Agência',
            'numeroConta.required' => 'Informe o número da conta bancária',
            'numeroConta.string' => 'O número da conta bancária deve ser uma string',
            'iban.required' => 'Informe o IBAN',
            'Assinante1.required' => 'Informe o nome do 1º Assinante',
            'Assinante2.required' => 'Informe o nome do 2º Assinante',
            'nif.required' => 'Informe o NIF',
            'impactoSocial.required' => 'Informe o impacto social do projecto',
            'impactoSocial.string' => 'O impacto social do projecto deve ser uma string',
            'impactoSocial.max' => 'O impacto social do projecto não pode ser maior que 555 caracteres',
            'empregosDirectos.required' => 'Informe a quantidade de emprego directos criados pelo projecto',
            'empregosDirectos.numeric' => 'A quantidade de emprego directos criados pelo projecto deve ser um número',
            'kitsDistribuidos.required' => 'Informe a quantidade de kits distribuidos pelo projecto',
            'kitsDistribuidos.numeric' => 'A quantidade de kits distribuidos pelo projecto deve ser um número',

            // Validações para actividades
            'actividadeAno.*.required' => 'O ano da actividade é obrigatório',
            'actividadeAno.*.numeric' => 'O ano da actividade deve ser um número',
            'actividadeDescricao.*.required' => 'A descrição da actividade é obrigatória',
            'actividadeDescricao.*.string' => 'A descrição da actividade deve ser uma string',
            'actividadeDataInicio.*.required' => 'A data de início da actividade é obrigatória',
            'actividadeDataInicio.*.date' => 'A data de início da actividade deve ser uma data válida',
            'actividadeDataFim.*.required' => 'A data de fim da actividade é obrigatória',
            'actividadeDataFim.*.date' => 'A data de fim da actividade deve ser uma data válida',
            'actividadeDataFim.*.after_or_equal' => 'A data de fim da actividade deve ser igual ou posterior à data de início',
            'actividadePercentual.*.required' => 'O percentual da actividade é obrigatório',
            'actividadePercentual.*.numeric' => 'O percentual da actividade deve ser um número',
            'actividadePercentual.*.min' => 'O percentual da actividade deve ser pelo menos 0',
            'actividadePercentual.*.*.max' => 'O percentual da actividade não pode ser maior que 100',

            // Validações para programação financeira
            'despesaAno.*.required' => 'O ano da despesa é obrigatório',
            'despesaAno.*.numeric' => 'O ano da despesa deve ser um número',
            'despesaValor.*.required' => 'O valor da despesa é obrigatório',
            'despesaValor.*.numeric' => 'O valor da despesa deve ser um número',
            'despesaValor.*.min' => 'O valor da despesa deve ser pelo menos 0',
            'despesaDescricao.*.required' => 'A descrição da despesa é obrigatória',
            'despesaDescricao.*.string' => 'A descrição da despesa deve ser uma string',
            'despesaDatainicial.*.required' => 'A data inicial da despesa é obrigatória',
            'despesaDatainicial.*.date' => 'A data inicial da despesa deve ser uma data válida',
            'despesaDatafinal.*.required' => 'A data final da despesa é obrigatória',
            'despesaDatafinal.*.date' => 'A data final da despesa deve ser uma data válida',
            'despesaDatafinal.*.after_or_equal' => 'A data final da despesa deve ser igual ou posterior à data inicial',
            'despesaCategoria.*.required' => 'A categoria da despesa é obrigatória',
        ];

    }
}
