<?php

namespace App\Http\Controllers;

use App\Models\Remuneracao;
use Illuminate\Http\Request;

class RemuneracaoController extends Controller
{
    public function index(Request $request)
    {
        $descricao = $request->input('descricao');
        $estado = $request->input('estado');

        $query = Remuneracao::query();

        if ($descricao) {
            $query->where('descricao', 'like', '%' . $descricao . '%');
        }

        if ($estado) {
            $query->where('status', $estado);
        }

        $remuneracoes = $query->latest()->paginate(10)->appends($request->query());

        return view('Administracao.Remuneracao', compact('remuneracoes'));
    }

    public function create()
    {
        // Não utilizado: a criação é feita via modal na listagem
        return redirect()->route('remuneracoes.index');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'tipo' => 'required|string|max:255',
            'descricao' => 'required|string|max:1000',
            'valor' => 'required|numeric|min:0',
            'observacao' => 'nullable|string|max:1000',
            'status' => 'required|in:Ativo,Inativo'
        ]);

        Remuneracao::create($validated);

        return redirect()->route('remuneracoes.index')
            ->with('success', 'Remuneração cadastrada com sucesso!');
    }

    public function show(Remuneracao $remuneracao)
    {
        // Opcional: implementar view de detalhes no futuro
        return redirect()->route('remuneracoes.index');
    }

    public function edit(Remuneracao $remuneracao)
    {
        // Opcional: implementar edição via modal/form dedicado
        return redirect()->route('remuneracoes.index');
    }

    public function update(Request $request, Remuneracao $remuneracao)
    {
        $validated = $request->validate([
            'tipo' => 'required|string|max:255',
            'descricao' => 'required|string|max:1000',
            'valor' => 'required|numeric|min:0',
            'observacao' => 'nullable|string|max:1000',
            'status' => 'required|in:Ativo,Inativo'
        ]);

        $remuneracao->update($validated);

        return redirect()->route('remuneracoes.index')
            ->with('success', 'Remuneração atualizada com sucesso!');
    }

    public function destroy(Remuneracao $remuneracao)
    {
        $remuneracao->delete();
        return redirect()->route('remuneracoes.index')
            ->with('success', 'Remuneração excluída com sucesso!');
    }

    public function toggleStatus($id)
    {
        $remuneracao = Remuneracao::findOrFail($id);
        $remuneracao->status = ($remuneracao->status == 'Ativo') ? 'Inativo' : 'Ativo';
        $remuneracao->save();

        $statusText = $remuneracao->status == 'Ativo' ? 'ativada' : 'desativada';
        return redirect()->route('remuneracoes.index')
            ->with('success', "Remuneração $statusText com sucesso!");
    }

}
