<?php

namespace App\Http\Controllers;

use App\Models\Projecto;
use Illuminate\Support\Facades\Auth;

class HomePromotorController extends Controller
{
    public function index()
    {
        // Obter o ID do usuário logado
        $userId = Auth::id();

        // Buscar todos os projetos do promotor
        $projectos = Projecto::where('tecnico_projectoFK', $userId)->get();

        // Contadores por status
        $totalProjectos = $projectos->count();
        $projectosPorStatus = [
            0 => $projectos->where('status', 0)->count(),
            1 => $projectos->where('status', 1)->count(),
            2 => $projectos->where('status', 2)->count(),
            3 => $projectos->where('status', 3)->count(),
            4 => $projectos->where('status', 4)->count(),
            5 => $projectos->where('status', 5)->count(),
        ];

        // Valores por status
        $valoresPorStatus = [
            0 => $projectos->where('status', 0)->sum('limiteorcamentalP'),
            1 => $projectos->where('status', 1)->sum('limiteorcamentalP'),
            2 => $projectos->where('status', 2)->sum('limiteorcamentalP'),
            3 => $projectos->where('status', 3)->sum('limiteorcamentalP'),
            4 => $projectos->where('status', 4)->sum('limiteorcamentalP'),
            5 => $projectos->where('status', 5)->sum('limiteorcamentalP'),
        ];

        // Projetos recentes
        $projectosRecentes = Projecto::where('tecnico_projectoFK', $userId)
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();

        // Taxas de progresso
        $taxaAprovacao = $totalProjectos > 0 ?
            round((($projectosPorStatus[2] + $projectosPorStatus[4] + $projectosPorStatus[5]) / $totalProjectos) * 100) : 0;

        // Todas as variáveis são enviadas para a view
        return view('Clientes.home', compact(
            'totalProjectos', 'projectosPorStatus', 'valoresPorStatus',
            'projectosRecentes', 'taxaAprovacao'
        ));
    }
}
