<?php

namespace App\Http\Controllers;

use App\Models\Banco;
use App\Models\Entidade;
use Illuminate\Http\Request;

class EntidadeController extends Controller
{
    //
    public function index()
    {

        $entidadeP = Entidade::where('tipo', '2')->orderByDesc('id')->paginate(4);

        return view('Administracao.EntidadePromotora', ['entidadesP' => $entidadeP]);

    }

    public function store(Request $request)
    {

        // Cadastro da entidade e as coordenadas bancarias

        $entidade = new Entidade;

        $entidade->nomeRegistro = $request->nomeRegistro;
        $entidade->nomeComercial = $request->sigla1;
        $entidade->tipo = '2';
        $entidade->nif = $request->nif;
        $entidade->endereco = $request->endereco;
        $entidade->email = $request->email;
        $entidade->pais = $request->pais;
        $entidade->cidade = $request->provincia;
        $entidade->website = $request->has('website') ? $request->website : null; // Condicional ternário
        $entidade->contactoPrimario = $request->contactoPrimario;
        $entidade->contactoSecundario = $request->has('contactoSecundario') ? $request->contactoSecundario : null; // Condicional ternário
        $entidade->obs = $request->obs;
        $entidade->status = 'on'; // Status on - Validação da data da saida de caixa

        $entidade->logo = $request->logotipo;

        // UPLOAD DOCUMENTO DO ENTIDADE
        if ($request->hasFile('documentacao') && $request->file('documentacao')->isValid()) {

            $requestDoc = $request->documentacao; // Endereço do documento
            $extensaoDoc = $requestDoc->extension(); // Extensão do documento

            $novoNomeDoc = md5($requestDoc->getClientOriginalName().strtotime('now')).'.'.$extensaoDoc; // Novo nome do doc no sistema
            $requestDoc->move(public_path('Doc/Entidades'), $novoNomeDoc); // Move para a pasta de Documentos do sistema

            $entidade->urldocumentacao = $novoNomeDoc;
        } else {

            $entidade->urldocumentacao = null;
        }

        // UPLOAD LOGOTIPO DA ENTIDADE
        if ($request->hasFile('logotipo') && $request->file('logotipo')->isValid()) {

            $requestDoc = $request->logotipo; // Endereço do Imagem
            $extensaoDoc = $requestDoc->extension(); // Extensão do Imagem

            $novoNomeDoc = md5($requestDoc->getClientOriginalName().strtotime('now')).'.'.$extensaoDoc; // Novo nome do doc no sistema
            $requestDoc->move(public_path('Img/Entidades'), $novoNomeDoc); // Move para a pasta de imagens do sistema

            $entidade->logo = $novoNomeDoc;
        } else {

            $entidade->logo == null;
        }

        $entidade->save();

        // Recupera o último registro da tabela entidade
        $ultimoregisto = Entidade::orderBy('id', 'desc')->first();

        foreach ($request->iten as $itemData) {
            $coordenadaBancaria = new Banco;
            $coordenadaBancaria->nome = $itemData['nomeInst'];
            $coordenadaBancaria->sigla = null;
            $coordenadaBancaria->numeroConta = $itemData['numeroConta'];
            $coordenadaBancaria->iban = $itemData['iban'];
            $coordenadaBancaria->swift = $itemData['swift'];
            $coordenadaBancaria->status = 'on'; // Definindo o status padrão como 'on'
            $coordenadaBancaria->assinante1 = $itemData['Assinante1'] ?? null;
            $coordenadaBancaria->assinante2 = $itemData['Assinante2'] ?? null;
            $coordenadaBancaria->assinante3 = $itemData['Assinante3'] ?? null;
            $coordenadaBancaria->assinante4 = $itemData['Assinante4'] ?? null;
            $coordenadaBancaria->entidade_id = $ultimoregisto->id; // Atribuindo o ID da entidade

            $coordenadaBancaria->save(); // Usando o método save() explicitamente

        }

        return redirect()->route('Listar-EntidadePromotora')->with('msg', ''.$request->nomeRegistro.' foi cadastrada com sucesso!');
    }
}
