<?php

namespace App\Http\Controllers;

use App\Http\Requests\EmpresaRequest;
use App\Models\Empresa;
use Illuminate\Http\Request;

class EmpresaController extends Controller
{
    //Listagem de Empresas
    public function index(){

        $empresa=Empresa::orderByDesc('id')->paginate(4);

        return view('Administracao.empresa',['empresas'=>$empresa]);
    }

    public function store(EmpresaRequest $request){

        //Validar formulario de cadastro de empresas
        $request->validated();

        //Cadastrar empresa
        $empresa=new Empresa();

        $empresa->nomeRegistro=$request->nomeRegistro;
        $empresa->nomeComercial=$request->nomeComercial;
        $empresa->nif=$request->nif;
        $empresa->email=$request->email;
        $empresa->endereco=$request->endereco;
        $empresa->cidade=$request->cidade;
        $empresa->pais=$request->pais;
        $empresa->website=$request->website;
        $empresa->logo=$request->logotipo;
        $empresa->urldocumentacao=$request->documentacao;
        $empresa->status='on';
        $empresa->obs=$request->obs;
        $empresa->contactoPrimario=$request->contactoPrimario;
        $empresa->contactoSecundario=$request->contactoSecundario;

        $empresa->save();

        return redirect()->route('empresa')->with('msg',''.$request->nomeComercial.' foi cadastrada com sucesso!');
    }
}
