<?php

namespace App\Http\Controllers;

use App\Models\Banco;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BancoController extends Controller
{
    //fff
    public function index()
    {
        $empresa=Banco::orderByDesc('id')->paginate(4);

        return view('Administracao.banco',['empresas'=>$empresa]);
    }

    public function store (Request $request)
    {
        //Validação dos campos do formulário de cadastro de banco - VALERY TSEYI @ GISCARD TECNLOGIAS
        $request->validated();

    try {
        DB::beginTransaction();

        $banco = new Banco();

        if($request->hasFile('urlLogo') && $request->file('urlLogo')->isValid()){

            $requestImage = $request->urlLogo; // Endereço da imagem 
            $extensaoImagem = $requestImage->extension(); // Extensão da imagem 

            $novoNomeImagem=md5($requestImage->getClientOriginalName().strtotime('now')).".".$extensaoImagem; // Novo nome da imagem no sistema
            $requestImage->move(public_path('Img/sistema'),$novoNomeImagem); // Move pra para de imagens do sistema

            $ $banco->urlLogo->urlimagem=$novoNomeImagem;      

        }
        

        //$banco->url= $request->urlLogo;
        $banco->nome = $request->nome;
        $banco->sigla = $request->sigla;
        $banco->numeroConta = $request->numeroConta;
        $banco->iban = $request->iban;
        $banco->swift = $request->swift;
        $banco->status = 'on';
        $banco->empresa_id = '1'; // $request->empresa_id; Buscar via autenticação da pelo user Admin logado

        
       

        if($banco->save()){

            $banco->save();
            DB::commit();
            return redirect()->route('banco')->with('msg','Banco cadastrado com sucesso!');

        }else{
            DB::rollBack();
            return redirect()->route('banco')->with('error','Não foi possível cadastrar o banco!');
        }
       


    } catch (\Throwable $e) {
        //Mensagem de erro
        DB::rollBack();
        return redirect()->route('banco')->with('error','Não foi possível cadastrar o banco!'.$e);

    }
    }
   
}