<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Session\TokenMismatchException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of exception types with their corresponding custom log levels.
     *
     * @var array<class-string<\Throwable>, \Psr\Log\LogLevel::*>
     */
    protected $levels = [
        //
    ];

    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<\Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

     
    public function render($request, Throwable $exception)
    {
        // Redireciona erros 404 para a página de login
        if ($exception instanceof NotFoundHttpException) {
            return redirect()->route('login'); // Redireciona para a rota nomeada "login"
        }
        elseif($exception instanceof TokenMismatchException) {
        return redirect()->route('login')->with('error', 'Sua sessão expirou. Por favor, faça login novamente.');
    }
    
    return parent::render($request, $exception);
    }
}
