<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CriarTabelaRelatorios extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'relatorios:criar-tabela';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Criar tabela de relatórios de execução';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            // Verificar se a tabela já existe
            if (Schema::hasTable('relatorios_execucao')) {
                $this->info('Tabela relatorios_execucao já existe!');
                return 0;
            }

            // Criar tabela usando SQL direto
            $sql = "
                CREATE TABLE relatorios_execucao (
                    id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
                    projeto_id BIGINT UNSIGNED NOT NULL,
                    usuario_id BIGINT UNSIGNED NOT NULL,
                    descricao_tecnica TEXT NOT NULL,
                    descricao_financeira TEXT NOT NULL,
                    periodo_inicio DATE NOT NULL,
                    periodo_fim DATE NOT NULL,
                    percentual_fisico DECIMAL(5,2) NULL,
                    valor_executado DECIMAL(15,2) NULL,
                    anexos LONGTEXT NULL,
                    observacoes TEXT NULL,
                    status VARCHAR(20) DEFAULT 'pendente',
                    motivo_rejeicao TEXT NULL,
                    aprovado_por BIGINT UNSIGNED NULL,
                    aprovado_em TIMESTAMP NULL,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
                );
            ";

            DB::statement($sql);
            
            $this->info('Tabela relatorios_execucao criada com sucesso!');
            return 0;
            
        } catch (\Exception $e) {
            $this->error('Erro ao criar tabela: ' . $e->getMessage());
            return 1;
        }
    }
}
