﻿@extends('Layout.LayoutBaseCliente')


@section('Conteudo')


    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div
                            class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                            <h4 class="mb-sm-0"><i class="ri-briefcase-fill label-icon align-middle fs-16 ms-2"></i> LISTAR
                                PROJECTO</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboards</a></li>
                                    <li class="breadcrumb-item active"> Criar novo projecto</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <!-- Mensagens do sistema -->

                @if (@session('msg'))

                    <script>
                        document.addEventListener('DOMContentLoaded', () => {

                            Swal.fire({
                                title: "Pronto!",
                                text: "{{ session('msg') }}",
                                icon: "success"
                            });
                        });

                    </script>

                    <!-- Mensagens do sistema -->

                @endif


            </div>
            <!-- container-fluid -->


            <div class="row">
                <div class="col-xxl-12">
                    <div class="card">
                        <div class="border">
                            <ul class="nav nav-pills custom-hover-nav-tabs">
                                <li class="nav-item">
                                    <a href="#custom-hover-customere" data-bs-toggle="tab" aria-expanded="false"
                                        class="nav-link active">
                                        <i class=" ri-mail-send-fill nav-icon nav-tab-position"></i>
                                        <h5 class="nav-titl nav-tab-position m-0">Submetidos</h5>
                                       
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#custom-hover-description" data-bs-toggle="tab" aria-expanded="true"
                                        class="nav-link">
                                        <i class=" ri-restart-fill nav-icon nav-tab-position"></i>
                                        <h5 class="nav-titl nav-tab-position m-0">Retornados</h5>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#custom-hover-reviews" data-bs-toggle="tab" aria-expanded="false"
                                        class="nav-link">
                                        <i class="ri-star-half-line nav-icon nav-tab-position"></i>
                                        <h5 class="nav-titl nav-tab-position m-0">Aprovados</h5>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#custom-hover-reviews1" data-bs-toggle="tab" aria-expanded="false"
                                        class="nav-link">
                                        <i class=" ri-list-settings-fill nav-icon nav-tab-position"></i>
                                        <h5 class="nav-titl nav-tab-position m-0">ConcluÃ­do</h5>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body">
                            <div class="tab-content text-muted">
                                <!-- INICIO DOS PROJECTOS SUBMETIDOS -->
                                <div class="tab-pane show active" id="custom-hover-customere">
                                    <br>

                                    <div class="row g-4 mb-4">
                                        <div class="col-sm-auto">
                                            <div>
                                                <a href="{{route('Criar-Projecto') }}" class="btn btn-success"><i
                                                        class="ri-add-line align-bottom me-1"></i> Submeter novo
                                                    Projecto</a>
                                            </div>
                                        </div>
                                        <div class="col-sm">
                                            <div class="d-flex justify-content-sm-end gap-2">
                                                <div class="search-box ms-2">
                                                    <input type="text" class="form-control" placeholder="Buscar...">
                                                    <i class="ri-search-line search-icon"></i>
                                                </div>
                                                <a href="{{--route('') --}}" class="btn btn-primary"><i
                                                        class=" ri-find-replace-line align-bottom me-1"></i></a>


                                            </div>
                                        </div>
                                    </div>

                                    <br>
                                    <h5>Projecto(s) submetido(s) para avaliaÃ§Ã£o</h5><br><br>

                                    <div class="row">
                                        @forelse ($projectosSumetidos as $projecto)
                                                <div class="col-xxl-3 col-sm-6 project-card">
                                                    <div class="card card-height-100">
                                                        <div class="card-body">
                                                            <div class="d-flex flex-column h-100 ">
                                                                <div class="d-flex">
                                                                    <div class="flex-grow-1">
                                                                        <p class="text-muted mb-4"><b>CÃ³digo:</b>
                                                                            {{ $projecto->codProjecto }}</p>
                                                                    </div>
                                                                    <div class="flex-shrink-0">
                                                                        <div class="d-flex gap-1 align-items-center">
                                                                            <button type="button"
                                                                                class="btn avatar-xs mt-n1 p-0 favourite-btn material-shadow-none">

                                                                            </button>
                                                                            <div class="dropdown">
                                                                                <button
                                                                                    class="btn btn-link text-muted p-1 mt-n2 py-0 text-decoration-none fs-15 material-shadow-none"
                                                                                    data-bs-toggle="dropdown" aria-haspopup="true"
                                                                                    aria-expanded="true">
                                                                                    <i data-feather="more-horizontal"
                                                                                        class="icon-sm"></i>
                                                                                </button>

                                                                                <div class="dropdown-menu dropdown-menu-end">
                                                                                    <a class="dropdown-item"
                                                                                        href="apps-projects-overview.html"><i
                                                                                            class="ri-eye-fill align-bottom me-2 text-muted"></i>
                                                                                        Ver</a>
                                                                                    <a class="dropdown-item"
                                                                                        href="apps-projects-create.html"><i
                                                                                            class="ri-pencil-fill align-bottom me-2 text-muted"></i>
                                                                                        Editar</a>
                                                                                    <div class="dropdown-divider"></div>
                                                                                    <a class="dropdown-item" href="#"
                                                                                        data-bs-toggle="modal"
                                                                                        data-bs-target="#removeProjectModal"><i
                                                                                            class="ri-delete-bin-fill align-bottom me-2 text-muted"></i>
                                                                                        Remover</a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="d-flex mb-2">
                                                                    <div class="flex-shrink-0 me-3">
                                                                        <div class="avatar-sm">
                                                                            <span
                                                                                class="avatar-title bg-warning-subtle rounded p-2">
                                                                                <img src="assets/images/brands/slack.png" alt=""
                                                                                    class="img-fluid p-1">
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h5 class="mb-1 fs-15"><a href="apps-projects-overview.html"
                                                                                class="text-body">{{ $projecto->nomeProjecto }}</a>
                                                                        </h5>
                                                                        <span
                                                                            class="text-muted text-truncate-two-lines mb-3">{!! $projecto->descricaoObjectivo !!}</span>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                        <div class="col-lg-12">
                                                                            <div class="mb-2 mb-lg-0">
                                                                                <p class="text-truncate-two-lines mb-4"><b>Gestor:</b> {{ $projecto->user->name ?? 'Pendente' }}</p>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-12">
                                                                            <div class="mb-2 mb-lg-2">
                                                                                <p class="text-truncate-two-lines mb-4"><b>Valor orÃ§amental:</b> {{ Number::currency($projecto->limiteorcamentalP, 'Kzs','AOA')}}</p>
                                                                            </div>
                                                                        </div>
                                                                </div>
                                                                <div class="mt-auto">
                                                                    <div class="d-flex mb-2">
                                                                        <div class="flex-grow-1">
                                                                            <div>Iniciativas/Grau de ExecuÃ§Ã£o</div>
                                                                        </div>
                                                                        <div class="flex-shrink-0">
                                                                            <div><i
                                                                                    class="ri-list-check align-bottom me-1 text-muted"></i>
                                                                                1/6</div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="progress progress-sm animated-progress">
                                                                        <div class="progress-bar bg-success" role="progressbar"
                                                                            aria-valuenow="34" aria-valuemin="0" aria-valuemax="100"
                                                                            style="width: 34%;"></div><!-- /.progress-bar -->
                                                                    </div><!-- /.progress -->
                                                                </div>
                                                            </div>

                                                        </div>
                                                        <!-- end card body -->
                                                        <div class="card-footer bg-transparent border-top-dashed py-2">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-grow-1">

                                                                </div>
                                                                <div class="flex-shrink-0">
                                                                    <div class="text-muted">
                                                                        <i class="ri-calendar-event-fill me-1 align-bottom"></i>
                                                                        {{ $projecto->created_at }}
                                                                    </div>
                                                                </div>

                                                            </div>

                                                        </div>
                                                        <!-- end card footer -->
                                                    </div>



                                                    <!-- FIM PROJECTO -->
                                                </div>

                                          
                                        @empty
                                            <div>Nenhum registro foi encontrado...</div>
                                        @endforelse

                                        {{ $projectosSumetidos->onEachSide(3)->links() }}
                                        <!-- PROJECTOS -->

                                    </div>
                                </div>
                                <!-- FIM PROJECTOS SUBMETIDOS -->
                                <!-- INICIO DOS PROJECTOS RETORNADOS -->
                                <div class="tab-pane" id="custom-hover-description">
                                    

                                    

                                    <br>
                                    <h5>Projecto(s) retornado(s) para avaliaÃ§Ã£o</h5><br><br>

                                    <div class="row">
                                        @forelse ($projectosRetornados as $projecto)
                                                <div class="col-xxl-3 col-sm-6 project-card">
                                                    <div class="card card-height-100">
                                                        <div class="card-body">
                                                            <div class="d-flex flex-column h-100 ">
                                                                <div class="d-flex">
                                                                    <div class="flex-grow-1">
                                                                        <p class="text-muted mb-4"><b>CÃ³digo:</b>
                                                                            {{ $projecto->codProjecto }}</p>
                                                                    </div>
                                                                    <div class="flex-shrink-0">
                                                                        <div class="d-flex gap-1 align-items-center">
                                                                            <button type="button"
                                                                                class="btn avatar-xs mt-n1 p-0 favourite-btn material-shadow-none">

                                                                            </button>
                                                                            <div class="dropdown">
                                                                                <button
                                                                                    class="btn btn-link text-muted p-1 mt-n2 py-0 text-decoration-none fs-15 material-shadow-none"
                                                                                    data-bs-toggle="dropdown" aria-haspopup="true"
                                                                                    aria-expanded="true">
                                                                                    <i data-feather="more-horizontal"
                                                                                        class="icon-sm"></i>
                                                                                </button>

                                                                                <div class="dropdown-menu dropdown-menu-end">
                                                                                    <a class="dropdown-item"
                                                                                        href="apps-projects-overview.html"><i
                                                                                            class="ri-eye-fill align-bottom me-2 text-muted"></i>
                                                                                        Ver</a>
                                                                                    <a class="dropdown-item"
                                                                                        href="apps-projects-create.html"><i
                                                                                            class="ri-pencil-fill align-bottom me-2 text-muted"></i>
                                                                                        Editar</a>
                                                                                    <div class="dropdown-divider"></div>
                                                                                    <a class="dropdown-item" href="#"
                                                                                        data-bs-toggle="modal"
                                                                                        data-bs-target="#removeProjectModal"><i
                                                                                            class="ri-delete-bin-fill align-bottom me-2 text-muted"></i>
                                                                                        Remover</a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="d-flex mb-2">
                                                                    <div class="flex-shrink-0 me-3">
                                                                        <div class="avatar-sm">
                                                                            <span
                                                                                class="avatar-title bg-warning-subtle rounded p-2">
                                                                                <img src="assets/images/brands/slack.png" alt=""
                                                                                    class="img-fluid p-1">
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="flex-grow-1">
                                                                        <h5 class="mb-1 fs-15"><a href="apps-projects-overview.html"
                                                                                class="text-body">{{ $projecto->nomeProjecto }}</a>
                                                                        </h5>
                                                                        <span
                                                                            class="text-muted text-truncate-two-lines mb-3">{!! $projecto->descricaoObjectivo !!}</span>
                                                                    </div>
                                                                    
                                                                </div>
                                                                <div class="row">
                                                                        <div class="col-lg-12">
                                                                            <div class="mb-2 mb-lg-0">
                                                                                <p class="text-truncate-two-lines mb-4"><b>Gestor:</b> {{ $projecto->user->name ?? 'Pendente' }}</p>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-12">
                                                                            <div class="mb-2 mb-lg-2">
                                                                                <p class="text-truncate-two-lines mb-4"><b>Valor orÃ§amental:</b> {{ Number::currency($projecto->limiteorcamentalP, 'Kzs','AOA')}}</p>
                                                                            </div>
                                                                        </div>
                                                                </div>
                                                                <div class="mt-auto">
                                                                    <div class="d-flex mb-2">
                                                                        <div class="flex-grow-1">
                                                                            <div>Iniciativas/Grau de ExecuÃ§Ã£o</div>
                                                                        </div>
                                                                        <div class="flex-shrink-0">
                                                                            <div><i
                                                                                    class="ri-list-check align-bottom me-1 text-muted"></i>
                                                                                1/6</div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="progress progress-sm animated-progress">
                                                                        <div class="progress-bar bg-success" role="progressbar"
                                                                            aria-valuenow="34" aria-valuemin="0" aria-valuemax="100"
                                                                            style="width: 34%;"></div><!-- /.progress-bar -->
                                                                    </div><!-- /.progress -->
                                                                </div>
                                                            </div>

                                                        </div>
                                                        <!-- end card body -->
                                                        <div class="card-footer bg-transparent border-top-dashed py-2">
                                                            <div class="d-flex align-items-center">
                                                                <div class="flex-grow-1">

                                                                </div>
                                                                <div class="flex-shrink-0">
                                                                    <div class="text-muted">
                                                                        <i class="ri-calendar-event-fill me-1 align-bottom"></i>
                                                                        {{ $projecto->created_at }}
                                                                    </div>
                                                                </div>

                                                            </div>

                                                        </div>
                                                        <!-- end card footer -->
                                                    </div>



                                                    <!-- FIM PROJECTO -->
                                                </div>

                                          
                                        @empty
                                            <div>Nenhum registro foi encontrado...</div>
                                        @endforelse

                                        {{ $projectosRetornados->onEachSide(3)->links() }}
                                        <!-- PROJECTOS -->

                                    </div>
                                </div>
                                <!-- FIM DOS PROJECTOS RETORNADOS -->
                                <!-- INICIO DOS PROJECTOS APROVADOS -->
                                <div class="tab-pane" id="custom-hover-reviews">
                                    <h6>Customer Reviews</h6>
                                    <div class="table-responsive">
                                        3
                                    </div>
                                </div>
                                <!-- FIM DOS PROJECTOS APROVADOS -->
                                <!-- INICIO DOS PROJECTOS CONCLUIDOS -->
                                <div class="tab-pane" id="custom-hover-reviews1">
                                    <h6>Customer Reviews</h6>
                                    <div class="table-responsive">
                                        4
                                    </div>
                                </div>
                                <!-- FIM DOS PROJECTOS CONCLUIDOS -->
                            </div>
                        </div><!-- end card-body -->
                    </div>
                </div>
                <!-- PROJECTOS -->

            </div>



        </div>




@endsection
